#include "ThingSpeak.h"
#include <OneWire.h>
#include <DHT.h>
#include <ESP8266WiFi.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>

#define OLED_RESET LED_BUILTIN  //4
Adafruit_SSD1306 display(OLED_RESET);    
    
    
    char ssid[] = "bera";    //  your network SSID (name) 
    char pass[] = "xxxxxxxxxx";   // your network password
    int status = WL_IDLE_STATUS;
    WiFiClient  client;

unsigned long myChannelNumber = 279012;
const char * myWriteAPIKey = "0T2YL145P41LNHKA";

#define DHTPIN D5   // what pin we're connected to
#define DHTTYPE DHT22   // DHT 22  (AM2302)

DHT dht(DHTPIN, DHTTYPE,11);   //this 11 is for ESP8266

#if (SSD1306_LCDHEIGHT != 32)
#error("Height incorrect, please fix Adafruit_SSD1306.h!");
#endif

void setup() {
  Serial.begin(115200);
  WiFi.begin(ssid, pass);
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }

  pinMode(DHTPIN,INPUT_PULLUP); 
  dht.begin();
 
  ThingSpeak.begin(client);
  display.begin(SSD1306_SWITCHCAPVCC, 0x3C);
}

void loop() {
  float h = dht.readHumidity();   
  float t = dht.readTemperature();  // Read temperature as Celsius 
  float f = dht.readTemperature(true);// Read temperature as Fahrenheit
  
  display.clearDisplay();
  display.setTextSize(1);
  display.setTextColor(WHITE);
  display.setCursor(0,0);

  display.print("Temp (C):");
  display.println(t,2);
  display.print("Hdty (%):");
  display.println(h,2);

  display.setTextSize(1);
  display.println("https://thingspeak.");
  display.println("com/channels/279012/");
  display.display();

  Serial.print(t,2);
  Serial.print(",");
  Serial.println(h,2);
  // Write to ThingSpeak. There are up to 8 fields in a channel, allowing you to store up to 8 different
  // pieces of information in a channel.  Here, we write to field 1.

  ThingSpeak.writeField(myChannelNumber, 1, h, myWriteAPIKey);
  WiFi.forceSleepBegin();  //Putting the Modem off
  delay(15000); 
  WiFi.forceSleepWake();  //waking up the modem

  ThingSpeak.writeField(myChannelNumber, 2, t, myWriteAPIKey);
  WiFi.forceSleepBegin();  //Putting the Modem off
  delay(15000); // ThingSpeak will only accept updates every 15 seconds.
  WiFi.forceSleepWake();  //waking up the modem
}
